require "behaviours/wander"
require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/follow"
require "behaviours/faceentity"

local MIN_FOLLOW_DIST = 3
local TARGET_FOLLOW_DIST = 4
local MAX_FOLLOW_DIST = 7

local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8

local ShadowFriendBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GetLeader(inst)
    return inst.components.follower.leader 
end

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end

function ShadowFriendBrain:OnStart()
    
    local root = PriorityNode(
    {
        ChaseAndAttack(self.inst, 100),
        Wander(self.inst, function() local player = GetPlayer() if player then return Vector3(player.Transform:GetWorldPosition()) end end, 20),
		
        Follow(self.inst, GetLeader, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
        IfNode(function() return GetLeader(self.inst) end, "has leader",            
            FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn )),
    }, .25)
    
    self.bt = BT(self.inst, root)
end

return ShadowFriendBrain